package spinner;

/*
 * (c) Copyright IBM Corp. 2000, 2001.
 * All Rights Reserved.
 */
 
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.graphics.*;
 
public class SpinnerTest {
      
public static void main (String [] args) {
	  Display display = new Display ();
	  Shell shell = new Shell (display);
	  shell.setLayout (new RowLayout ());
 
	  final Spinner spinner = new Spinner (shell, 0);
	  spinner.setMaximum (999);
	  System.out.println ("max set to " + spinner.getMaximum ());
	  spinner.setSelection (500);
	  System.out.println ("selection set to " + spinner.getSelection ());
	  spinner.setMinimum (100);
	  System.out.println ("min set to " + spinner.getMinimum ());
	  Font font = new Font (display, "Courier", 20, SWT.NORMAL);
	  spinner.setFont (font);
	  spinner.addSelectionListener (new SelectionAdapter () {
			public void widgetSelected (SelectionEvent e) {
				  System.out.println (spinner.getSelection ());
			}
	  });
	  shell.pack ();
	  shell.open ();          
	  while (!shell.isDisposed ()){
			if (!display.readAndDispatch ()) display.sleep ();
	  }
	  font.dispose ();
}
}
